/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.fun;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.DrawSlot;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.PlaySlot;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.fun.FunMenu;
import dev.lucaargolo.charta.item.CardDeckItem;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.network.LastFunPayload;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3914;
import net.minecraft.class_8710;

public class FunGame
extends CardGame<FunGame> {
    public static final int LAST_COOLDOWN = 30;
    private final GameOption.Number LAST_DRAW_AMOUNT = new GameOption.Number(2, 0, 6, (class_2561)class_2561.method_43471((String)"rule.charta.last_draw_amount"), (class_2561)class_2561.method_43471((String)"rule.charta.last_draw_amount.description"));
    private final GameOption.Bool STACK_ANY_PLUS2_ON_PLUS2 = new GameOption.Bool(true, (class_2561)class_2561.method_43471((String)"rule.charta.stack_any_plus2_on_plus2"), (class_2561)class_2561.method_43471((String)"rule.charta.stack_any_plus2_on_plus2.description"));
    private final GameOption.Bool STACK_SAME_PLUS2_ON_PLUS2 = new GameOption.Bool(true, (class_2561)class_2561.method_43471((String)"rule.charta.stack_same_plus2_on_plus2"), (class_2561)class_2561.method_43471((String)"rule.charta.stack_same_plus2_on_plus2.description"));
    private final GameOption.Bool STACK_PLUS4_ON_PLUS2 = new GameOption.Bool(true, (class_2561)class_2561.method_43471((String)"rule.charta.stack_plus4_on_plus2"), (class_2561)class_2561.method_43471((String)"rule.charta.stack_plus4_on_plus2.description"));
    private final GameOption.Bool STACK_PLUS4_ON_PLUS4 = new GameOption.Bool(false, (class_2561)class_2561.method_43471((String)"rule.charta.stack_plus4_on_plus4"), (class_2561)class_2561.method_43471((String)"rule.charta.stack_plus4_on_plus4.description"));
    private final GameOption.Bool STACK_SAME_PLUS2_ON_PLUS4 = new GameOption.Bool(false, (class_2561)class_2561.method_43471((String)"rule.charta.stack_same_plus2_on_plus4"), (class_2561)class_2561.method_43471((String)"rule.charta.stack_same_plus2_on_plus4.description"));
    private final GameOption.Bool STACK_ANY_PLUS2_ON_PLUS4 = new GameOption.Bool(false, (class_2561)class_2561.method_43471((String)"rule.charta.stack_any_plus2_on_plus4"), (class_2561)class_2561.method_43471((String)"rule.charta.stack_any_plus2_on_plus4.description"));
    private final PlaySlot playPile;
    private final DrawSlot drawPile;
    public final GameSlot suits = new GameSlot(this){

        @Override
        public boolean removeAll() {
            return false;
        }
    };
    public boolean isChoosingWild;
    public Suit currentSuit;
    private final boolean[] saidLast;
    private final int[] lastCooldown;
    public boolean canDraw = true;
    public int drawStack = 0;
    public boolean startedDraw = false;
    public boolean reversed = false;
    private final Random random = new Random();

    public FunGame(List<CardPlayer> players, CardDeck deck) {
        super(players, deck);
        this.saidLast = new boolean[players.size()];
        this.lastCooldown = new int[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            this.saidLast[i] = false;
            this.lastCooldown[i] = 0;
        }
        this.drawPile = this.addSlot(new DrawSlot(this, new LinkedList<Card>(), 47.5f, 62.5f, 0.0f, 0.0f, () -> this.canDraw));
        this.playPile = this.addSlot(new PlaySlot(this, new LinkedList<Card>(), 87.5f, 62.5f, 0.0f, 0.0f, this.drawPile));
    }

    @Override
    public GameSlot getPlayerHand(CardPlayer player) {
        return player == this.getCurrentPlayer() && this.isChoosingWild ? this.suits : super.getPlayerHand(player);
    }

    @Override
    protected GameSlot createPlayerHand(CardPlayer player) {
        return new GameSlot(player.hand()){

            @Override
            public void onInsert(CardPlayer player, List<Card> cards) {
                super.onInsert(player, cards);
                if (FunGame.this.drawPile.isDraw()) {
                    player.play(null);
                    FunGame.this.drawPile.setDraw(false);
                }
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        };
    }

    @Override
    public List<GameOption<?>> getOptions() {
        return List.of(this.LAST_DRAW_AMOUNT, this.STACK_ANY_PLUS2_ON_PLUS2, this.STACK_SAME_PLUS2_ON_PLUS2, this.STACK_PLUS4_ON_PLUS2, this.STACK_PLUS4_ON_PLUS4, this.STACK_SAME_PLUS2_ON_PLUS4, this.STACK_ANY_PLUS2_ON_PLUS4);
    }

    @Override
    public AbstractCardMenu<FunGame> createMenu(int containerId, class_1661 playerInventory, class_3218 level, class_2338 pos, CardDeck deck) {
        return new FunMenu(containerId, playerInventory, class_3914.method_17392((class_1937)level, (class_2338)pos), deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    @Override
    public Predicate<CardDeck> getDeckPredicate() {
        return deck -> {
            boolean noEmpty = deck.getCards().stream().filter(c -> c.getSuit() == Suit.BLANK).findAny().isEmpty();
            boolean red = deck.getSuitTranslatableKey(Suit.SPADES).contains("red");
            boolean yellow = deck.getSuitTranslatableKey(Suit.HEARTS).contains("yellow");
            boolean green = deck.getSuitTranslatableKey(Suit.CLUBS).contains("green");
            boolean blue = deck.getSuitTranslatableKey(Suit.DIAMONDS).contains("blue");
            return noEmpty && (red || yellow || green || blue);
        };
    }

    @Override
    public Predicate<Card> getCardPredicate() {
        return card -> true;
    }

    @Override
    public void startGame() {
        this.drawPile.clear();
        this.playPile.clear();
        this.drawPile.addAll(this.gameDeck);
        this.drawPile.shuffle();
        for (Object player : this.players) {
            player.resetPlay();
            this.getPlayerHand((CardPlayer)player).clear();
            this.getCensoredHand((CardPlayer)player).clear();
        }
        for (int i = 0; i < 7; ++i) {
            for (CardPlayer player : this.players) {
                this.scheduledActions.add(() -> {
                    player.playSound(ModSounds.CARD_DRAW);
                    this.dealCards(this.drawPile, player, 1);
                });
                this.scheduledActions.add(() -> {});
            }
        }
        Card last = this.drawPile.removeLast();
        while (last != null && (last.getRank() == Rank.BLANK || last.getRank() == Rank.JACK || last.getRank() == Rank.QUEEN || last.getRank() == Rank.KING || last.getRank() == Rank.JOKER)) {
            this.drawPile.add(last);
            this.drawPile.shuffle();
            last = this.drawPile.removeLast();
        }
        assert (last != null);
        last.flip();
        Card startingCard = last;
        this.scheduledActions.add(() -> {
            this.playPile.addLast(startingCard);
            this.currentSuit = startingCard.getSuit();
        });
        this.currentPlayer = this.getNextPlayer();
        this.isChoosingWild = false;
        this.isGameReady = false;
        this.isGameOver = false;
        this.table((class_2561)class_2561.method_43471((String)"message.charta.game_started"));
        this.table((class_2561)class_2561.method_43469((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
    }

    private void shufflePiles() {
        Card lastCard = this.playPile.removeLast();
        this.playPile.forEach(Card::flip);
        this.drawPile.addAll(this.playPile);
        this.drawPile.shuffle();
        this.playPile.clear();
        this.playPile.add(lastCard);
        this.table((class_2561)class_2561.method_43471((String)"message.charta.piles_shuffled"));
    }

    @Override
    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        if (this.drawPile.isEmpty()) {
            if (this.playPile.size() > 1) {
                this.shufflePiles();
            } else {
                this.endGame();
            }
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play == null) {
                boolean canPlay = false;
                if (this.currentPlayer.shouldCompute()) {
                    this.dealCards(this.drawPile, this.currentPlayer, 1);
                    this.currentPlayer.playSound(ModSounds.CARD_DRAW);
                }
                this.play(this.currentPlayer, (class_2561)class_2561.method_43471((String)"message.charta.drew_a_card"));
                if (this.drawStack > 0) {
                    this.startedDraw = true;
                    --this.drawStack;
                    this.canDraw = this.drawStack > 0;
                } else {
                    this.canDraw = false;
                }
                if (!this.startedDraw) {
                    canPlay = this.getBestPlay(this.currentPlayer) != null;
                }
                this.saidLast[this.getPlayers().indexOf((Object)this.currentPlayer)] = false;
                if (!this.canDraw && !canPlay) {
                    this.startedDraw = false;
                    this.nextPlayerAndRunGame();
                } else {
                    this.runGame();
                }
            } else if (!this.currentPlayer.shouldCompute() || this.canPlay(this.currentPlayer, (CardPlay)play)) {
                Card card = play.cards().getLast();
                this.currentPlayer.playSound(ModSounds.CARD_PLAY);
                this.currentSuit = card.getSuit();
                if (this.isChoosingWild) {
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.chose_a_suit", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getSuitTranslatableKey(this.currentSuit)).method_54663(this.deck.getSuitColor(this.currentSuit))}));
                    if (!this.currentPlayer.shouldCompute()) {
                        this.playPile.removeLast();
                    }
                    this.isChoosingWild = false;
                } else {
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.played_a_card", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getCardTranslatableKey(card)).method_54663(this.deck.getCardColor(card))}));
                }
                if (this.currentPlayer.shouldCompute() && this.getPlayerHand(this.currentPlayer).remove(card)) {
                    this.getCensoredHand(this.currentPlayer).removeLast();
                    this.playPile.addLast(card);
                }
                if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
                    this.endGame();
                } else if (card.getRank() == Rank.BLANK || card.getRank() == Rank.JOKER) {
                    if (card.getRank() == Rank.JOKER) {
                        this.drawStack += 4;
                    }
                    if (this.currentPlayer.shouldCompute()) {
                        this.currentSuit = this.getMostFrequentSuit(this.currentPlayer);
                        this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.chose_a_suit", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getSuitTranslatableKey(this.currentSuit))}));
                        this.nextPlayerAndRunGame();
                    } else {
                        this.isChoosingWild = true;
                        this.suits.clear();
                        this.suits.addAll(this.gameSuits.stream().map(s -> new Card((Suit)((Object)((Object)s)), Rank.TEN)).toList());
                        this.canDraw = false;
                        this.runGame();
                    }
                } else {
                    if (card.getRank() == Rank.JACK) {
                        this.currentPlayer = this.getNextPlayer();
                        this.table((class_2561)class_2561.method_43469((String)"message.charta.player_was_skipped", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
                    } else if (card.getRank() == Rank.QUEEN) {
                        boolean bl = this.reversed = !this.reversed;
                        if (this.players.size() == 2) {
                            this.currentPlayer = this.getNextPlayer();
                        }
                        this.table((class_2561)class_2561.method_43471((String)"message.charta.game_reversed"));
                    } else if (card.getRank() == Rank.KING) {
                        this.drawStack += 2;
                    }
                    this.nextPlayerAndRunGame();
                }
            }
        });
    }

    private void nextPlayerAndRunGame() {
        this.canDraw = true;
        this.currentPlayer = this.getNextPlayer();
        if (this.drawStack > 0) {
            this.table((class_2561)class_2561.method_43469((String)"message.charta.its_player_turn_draw_stack", (Object[])new Object[]{this.currentPlayer.getColoredName(), this.drawStack}));
        } else {
            this.table((class_2561)class_2561.method_43469((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
        }
        this.runGame();
    }

    @Override
    public void endGame() {
        if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
            this.currentPlayer.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.you_won").method_27692(class_124.field_1060), (class_2561)class_2561.method_43471((String)"message.charta.congratulations"));
            this.getPlayers().stream().filter(player -> player != this.currentPlayer).forEach(player -> player.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.you_lost").method_27692(class_124.field_1061), (class_2561)class_2561.method_43469((String)"message.charta.won_the_match", (Object[])new Object[]{this.currentPlayer.getName()})));
        } else {
            this.getPlayers().forEach(player -> {
                player.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.draw").method_27692(class_124.field_1054), (class_2561)class_2561.method_43471((String)"message.charta.no_winner"));
                player.sendMessage((class_2561)class_2561.method_43471((String)"message.charta.match_unable").method_27692(class_124.field_1065));
            });
        }
        this.isGameOver = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isGameReady) {
            for (int i = 0; i < this.getPlayers().size(); ++i) {
                CardPlayer player = this.getPlayers().get(i);
                boolean didntSayLast = this.didntSayLast(player);
                if (player.shouldCompute()) {
                    if (didntSayLast && this.lastCooldown[i] % 15 == 0 && this.random.nextBoolean()) {
                        this.sayLast(player);
                    }
                    for (int j = 0; j < this.getPlayers().size(); ++j) {
                        CardPlayer other = this.getPlayers().get(j);
                        if (this.lastCooldown[j] <= 30 || !this.random.nextBoolean() || !this.didntSayLast(other)) continue;
                        this.sayLast(player);
                    }
                }
                if (!didntSayLast) continue;
                int n = i;
                this.lastCooldown[n] = this.lastCooldown[n] + 1;
            }
        }
    }

    @Override
    public boolean canPlay(CardPlayer player, CardPlay play) {
        List<Card> cards = play.cards();
        if (cards.size() != 1) {
            return false;
        }
        Card card = cards.getLast();
        Card lastCard = this.playPile.getLast();
        if (!this.isGameReady || lastCard == null) {
            return false;
        }
        if (this.isChoosingWild) {
            return true;
        }
        if (this.drawStack > 0) {
            boolean isPlus4;
            if (this.startedDraw) {
                return false;
            }
            boolean bl = isPlus4 = lastCard.getRank() == Rank.JOKER;
            if (isPlus4) {
                return (Boolean)this.STACK_PLUS4_ON_PLUS4.get() != false && card.getRank() == Rank.JOKER || (Boolean)this.STACK_ANY_PLUS2_ON_PLUS4.get() != false && card.getRank() == Rank.KING || (Boolean)this.STACK_SAME_PLUS2_ON_PLUS4.get() != false && card.getRank() == Rank.KING && card.getSuit() == this.currentSuit;
            }
            return (Boolean)this.STACK_PLUS4_ON_PLUS2.get() != false && card.getRank() == Rank.JOKER || (Boolean)this.STACK_ANY_PLUS2_ON_PLUS2.get() != false && card.getRank() == Rank.KING || (Boolean)this.STACK_SAME_PLUS2_ON_PLUS2.get() != false && card.getRank() == Rank.KING && card.getSuit() == this.currentSuit;
        }
        return card.getRank() == Rank.BLANK || card.getRank() == Rank.JOKER || card.getRank() == lastCard.getRank() || card.getSuit() == this.currentSuit;
    }

    public void sayLast(CardPlayer current) {
        for (int i = 0; i < this.players.size(); ++i) {
            CardPlayer player = (CardPlayer)this.players.get(i);
            if (!this.didntSayLast(player)) continue;
            this.table((class_2561)class_2561.method_43469((String)"message.charta.player_said_last", (Object[])new Object[]{current.getColoredName()}));
            if (player == current) {
                player.playSound((class_3414)class_3417.field_14622.comp_349());
                this.saidLast[i] = true;
                this.lastCooldown[i] = 0;
                continue;
            }
            if (this.lastCooldown[i] <= 30) continue;
            int drawAmount = (Integer)this.LAST_DRAW_AMOUNT.get();
            if (this.drawPile.size() < drawAmount) {
                this.shufflePiles();
            }
            if (this.drawPile.size() >= drawAmount) {
                this.players.forEach(p -> {
                    class_1309 entity = p.getEntity();
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)entity;
                        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new LastFunPayload(CardDeckItem.getDeck(this.deck)));
                    }
                });
                this.table((class_2561)class_2561.method_43469((String)"message.charta.player_automatically_drew_cards", (Object[])new Object[]{player.getColoredName(), drawAmount}));
                this.dealCards(this.drawPile, player, drawAmount);
            } else {
                this.endGame();
            }
            this.saidLast[i] = true;
            this.lastCooldown[i] = 0;
        }
    }

    public boolean canDoLast() {
        return this.isGameReady && this.getPlayers().stream().anyMatch(this::didntSayLast);
    }

    public boolean didntSayLast(CardPlayer player) {
        int index = this.getPlayers().indexOf(player);
        if (this.saidLast[index]) {
            return false;
        }
        int size = (int)this.getFullHand(player).count();
        return size == 1;
    }

    private CardPlayer getNextPlayer() {
        if (this.currentPlayer == null) {
            return this.getPlayers().getFirst();
        }
        int indexOf = this.getPlayers().indexOf(this.currentPlayer);
        if (this.reversed) {
            if (indexOf - 1 >= 0) {
                return this.getPlayers().get(indexOf - 1);
            }
            return this.getPlayers().getLast();
        }
        return this.getPlayers().get((indexOf + 1) % this.players.size());
    }
}

